rm -f gap_vs_supercell_size.dat

for i in "2x2x2" "3x3x3" "4x4x4" 
do
   nions=`grep NIONS OUTCAR.${i} | awk '{print $12}'`
   occ_pristine=`grep -A $((nions * 2)) " band energies" OUTCAR.${i} | tail -3 | awk '{sum += $2} END {print sum/NR}'`
   con_pristine=`grep -A $((nions * 2 + 6)) " band energies" OUTCAR.${i} | tail -6 | awk '{sum += $2} END {print sum/NR}'`
   occ_oneshot=`grep -A $((nions * 2)) " band energies" OUTCAR.${i}_T0 | tail -3 | awk '{sum += $2} END {print sum/NR}'`
   con_oneshot=`grep -A $((nions * 2 + 6)) " band energies" OUTCAR.${i}_T0 | tail -6 | awk '{sum += $2} END {print sum/NR}'`
   gap_pristine=$(awk -v con="$con_pristine" -v occ="$occ_pristine" 'BEGIN {print con - occ}')
   gap_oneshot=$(awk -v con="$con_oneshot" -v occ="$occ_oneshot" 'BEGIN {print con - occ}')
   gap_diff=`awk -v gpris=$gap_pristine -v gonesh=$gap_oneshot 'BEGIN{print gonesh-gpris}'`
   echo $i $gap_diff >> gap_vs_supercell_size.dat
   echo $i $gap_diff
done
